<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCarsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('cars', function (Blueprint $table) {
            $table->id();

            $table->foreignId('brand_id')
                  ->constrained('car_brands')
                  ->restrictOnDelete();

            $table->foreignId('model_id')
                  ->constrained('car_models')
                  ->restrictOnDelete();

            $table->year('year');
            $table->decimal('price', 12, 2);
            $table->integer('mileage')->nullable();

            $table->string('transmission')->nullable(); // automatic / manual
            $table->string('fuel_type')->nullable();     // petrol / diesel / hybrid
            $table->string('color')->nullable();
            $table->string('condition')->nullable();     // new / used / foreign used

            $table->boolean('registered')->default(false);
            $table->boolean('negotiable')->default(false);
            $table->boolean('swap_allowed')->default(false);

            $table->longText('description')->nullable();

            $table->enum('status', ['available', 'sold', 'hidden'])
                  ->default('available');

            $table->timestamps();

            $table->index(['brand_id', 'model_id', 'year', 'price']);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('cars');
    }
}
