<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">

    <title>{{ $car->brand }} {{ $car->model }} {{ $car->year }}</title>

    <!-- Open Graph -->
    <meta property="og:title" content="{{ $car->brand }} {{ $car->model }} {{ $car->year }}" />
    <meta property="og:description" content="{{ Str::limit($car->description, 150) }}" />
    <meta property="og:image" content="{{ $car->image_url }}" />
    <meta property="og:url" content="{{ url('/car/' . $car->slug) }}" />
    <meta property="og:type" content="website" />

    <!-- Twitter -->
    <meta name="twitter:card" content="summary_large_image" />
    <meta name="twitter:image" content="{{ $car->image_url }}" />

</head>

<body>
    <p>Loading...</p>
</body>

</html>
