<?php


use App\Http\Controllers\AuthController;
use App\Http\Controllers\CarBrandController;
use App\Http\Controllers\CarController;
use App\Http\Controllers\CarModelController;
use App\Http\Controllers\FaqController;
use App\Http\Controllers\PageController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\VendorController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::get('/clear-cache', function () {
    $exitCode = Artisan::call('config:cache');

    return 'DONE'; // Return anything
});

Route::get('/create-symlink', function () {
    symlink(storage_path('/app/public'), public_path('storage'));
    echo 'Symlink Created. Thanks';
});

Route::get('/', function () {
    $data = [
        'message' => 'Welcome to our API',
    ];

    return response()->json($data, 200);
});


Route::get('/get-site-info', [UserController::class, 'getSiteInfo']);
Route::get('/get-site-pages', [UserController::class, 'getSitePages']);
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);
Route::get('/user', [AuthController::class, 'getUser']);
Route::post('/forgot-password', [AuthController::class, 'forgotPassword']);
Route::get('/reset-password/{token}', function ($token) {
    return response()->json(['token' => $token]);
})->name('password.reset');




Route::prefix('cars')->group(function () {
    Route::get('get-cars/{status?}/{featured?}/{search?}/{queryData?}/{offset?}', [CarController::class, 'index']);
    Route::get('get-promo-cars/{status?}', [CarController::class, 'getPromoCars']);
    Route::get('{id}', [CarController::class, 'show']);
});


Route::prefix('brands')->group(function () {
    Route::get('/', [CarBrandController::class, 'index']);
});

Route::prefix('testimonials')->group(function () {
    Route::get('/', [TestimonialController::class, 'index']);
    Route::get('{id}', [TestimonialController::class, 'show']);
});

/*
  |--------------------------------------------------------------------------
  | Protected Routes
  |--------------------------------------------------------------------------
  */

Route::middleware('jwt.verify')->group(function () {
    Route::get('/dashboard', function () {
        return response()->json(['message' => 'Welcome to dashboard'], 200);
    });

    Route::post('/update-site-info', [UserController::class, 'saveSiteInfo']);
    Route::post('/update-site-page', [UserController::class, 'saveSitePage']);
    Route::post('/update-site-hero-slide-images', [UserController::class, 'saveSiteSlideImages']);

    Route::get('/home-data', [
        UserController::class,
        'getHomePageData',
    ]);
    Route::post('/update-user', [AuthController::class, 'updateUser']);
    Route::post('/change-password', [
        AuthController::class,
        'changeUserPassword',
    ]);

    /*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
*/

    // Core entities

    Route::prefix('users')->group(function () {
        Route::get('/', [UserController::class, 'index']);
        Route::post('/', [UserController::class, 'store']);
        Route::post('/import-students', [UserController::class, 'importStudents']);
        Route::get('/{id}', [UserController::class, 'show']);
        Route::put('/{id}', [UserController::class, 'update']);
        Route::delete('/{id}', [UserController::class, 'destroy']);
    });

    Route::prefix('pages')->group(function () {
        Route::get('/', [PageController::class, 'index']);
        Route::get('{slug}', [PageController::class, 'show']);
    });

    Route::prefix('faqs')->group(function () {
        Route::get('/', [FaqController::class, 'index']);
    });

    Route::prefix('brands')->group(function () {
        Route::post('disable-brand', [CarBrandController::class, 'disabledOrDeleteBranch']);
        Route::post('edit-brand', [CarBrandController::class, 'editBranch']);
        Route::get('{slug}', [CarBrandController::class, 'show']);
        Route::get('{brandId}/models', [CarModelController::class, 'byBrand']);
    });

    Route::prefix('cars')->group(function () {
        Route::post('/', [CarController::class, 'store']);
        Route::post('update-car', [CarController::class, 'update']);
        Route::post('change-status', [CarController::class, 'toggleStatus']);
        Route::get('dashboard/analytics', [CarController::class, 'analytics']);
        Route::delete('{id}', [CarController::class, 'destroy']);
    });

    Route::prefix('users')->group(function () {
        Route::get('profile', [UserController::class, 'profile']);
    });

    Route::prefix('brands')->group(function () {
        Route::post('/', [CarBrandController::class, 'store']);
    });

    Route::prefix('models')->group(function () {
        Route::get('/', [CarModelController::class, 'index']);
        Route::post('/', [CarModelController::class, 'store']);
        Route::post('/edit-model', [CarModelController::class, 'editModel']);
        Route::post('disable-model', [CarModelController::class, 'disabledOrDeleteModel']);
    });

    Route::prefix('vendors')->group(function () {
        Route::get('/', [VendorController::class, 'index']);
        Route::get('{id}', [VendorController::class, 'show']);
        Route::post('/', [VendorController::class, 'store']);
        Route::post('edit-vendor', [VendorController::class, 'update']);
        Route::patch('{id}/toggle-status', [VendorController::class, 'toggleStatus']);
        Route::delete('{id}', [VendorController::class, 'destroy']);
    });

    Route::prefix('testimonials')->group(function () {
        Route::post('/', [TestimonialController::class, 'store']);
        Route::post('edit-testimonial', [TestimonialController::class, 'update']);
        Route::delete('{id}', [TestimonialController::class, 'destroy']);
    });
});
